/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.util;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.IProcessRunner;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ProcessRunner;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.UIPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class WorkbenchBrowserUtil {
    private static final Pattern ARG_SPLITTER = Pattern.compile("([^\"]\\S*|\".+?\")\\s*");
    private IProcessRunner runner;
    private IWorkbenchBrowserSupport support;

    private WorkbenchBrowserUtil() {
        this((IProcessRunner)new ProcessRunner(), PlatformUI.getWorkbench().getBrowserSupport());
    }

    protected WorkbenchBrowserUtil(IProcessRunner runner, IWorkbenchBrowserSupport support) {
        this.runner = runner;
        this.support = support;
    }

    public static void launchExternalBrowser(String url) {
        try {
            WorkbenchBrowserUtil.launchExternalBrowser(new URL(url));
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
        }
    }

    public static void launchExternalBrowser(URL url) {
        WorkbenchBrowserUtil.launchExternalBrowser(url, null);
    }

    public static IWebBrowser launchExternalBrowser(String url, String browserId) {
        try {
            return WorkbenchBrowserUtil.launchExternalBrowser(new URL(url), browserId);
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public static IWebBrowser launchExternalBrowser(URL url, String browserId) {
        return new WorkbenchBrowserUtil().doLaunchExternalBrowser(url, browserId);
    }

    IWebBrowser doLaunchExternalBrowser(URL url, String browserId) {
        IWebBrowser webBrowser;
        if (browserId != null) {
            try {
                webBrowser = this.support.createBrowser(128, browserId, null, null);
                if (webBrowser != null) {
                    webBrowser.openURL(url);
                    return webBrowser;
                }
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
            }
        }
        try {
            webBrowser = this.support.getExternalBrowser();
            webBrowser.openURL(url);
            return webBrowser;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
            WorkbenchBrowserUtil.launchBrowserByCommand(url);
            return null;
        }
    }

    public static void launchBrowserByCommand(URL url) {
        new WorkbenchBrowserUtil().doLaunchBrowserByCommand(url);
    }

    void doLaunchBrowserByCommand(URL url) {
        if (this.launchProgram(url)) {
            return;
        }
        if (this.isMac()) {
            this.runner.runInBackground(new String[]{"open", url.toString()});
        } else if (this.isWindows()) {
            String output;
            int index;
            ArrayList<String> args = new ArrayList<String>();
            IStatus result = this.runner.runInBackground(new String[]{"reg", "query", "HKEY_CLASSES_ROOT\\http\\shell\\open\\command"});
            if (result.isOK() && (index = (output = result.getMessage()).indexOf("REG_SZ")) != -1) {
                output = output.substring(index + 6);
                String firstLine = StringUtil.LINE_SPLITTER.split(output)[0].trim();
                Matcher m = ARG_SPLITTER.matcher(firstLine);
                while (m.find()) {
                    args.add(StringUtil.stripQuotes((String)m.group(1)).replace("%1", url.toString()));
                }
            }
            if (args.isEmpty()) {
                args.add("iexplore.exe");
                args.add(url.toString());
            }
            this.runner.runInBackground(args.toArray(new String[args.size()]));
        } else {
            this.runner.runInBackground(new String[]{"xdg-open", url.toString()});
        }
    }

    protected boolean launchProgram(URL url) {
        return Program.launch((String)url.toString());
    }

    protected boolean isWindows() {
        return PlatformUtil.isWindows();
    }

    protected boolean isMac() {
        return PlatformUtil.isMac();
    }

    public static IWebBrowser openURL(String url) {
        return new WorkbenchBrowserUtil().doOpenURL(url);
    }

    IWebBrowser doOpenURL(String url) {
        try {
            IWebBrowser webBrowser = this.support.createBrowser(null);
            if (webBrowser != null) {
                webBrowser.openURL(new URL(url));
            }
            return webBrowser;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }
}

